# Vespucci 21.0 Highlights

2025-03-05

__The state file of this version is incompatible with that of previous builds, please upload or save any changes before you update.__

### Panoramax support

The release adds support for a Panoramax layer similar to the existing Mapillary one. Currently it renders vector tiles from panoramax.xyz and uses that as the default API instance. 

Note that we currently display the imagery in the normal photo viewer and not a 360° specific one. Further some Panoramax sequences are extremely long which can cause issues with fetching the sequence data.

### Improved locking behaviour

Many actions can happen concurrently in Vespucci, for example you might be moving a way at the same time that additional data is being downloaded, superfluous data is being pruned and all of it is being displayed on the screen. For this release we've simplified and rearranged the code that locks some critical sections against concurrent access and in particular do not wait to obtain locks in the rendering code. This should avoid the infrequent, but annoying, situations that could cause the UI to lock up.    

### Retry a failed upload and support for compressed uploads

If you are mapping in a region that has questionable Internet connectivity you may have experienced the problem that if a upload fails it is unclear if you can retry and if you can't you are left a bit stuck. See [diary post on handling failed uploads](https://www.openstreetmap.org/user/SimonPoole/diary/406218).

Vespucci 21 will try to determine the state of your upload if it fails and suggest the best course of action. If necessary it now supports updating the edits in the device from the data successfully uploaded changes. (Vespucci has supported updating from a osmChange file since early 2019, this is different as for newly created elements 
we need to use some heuristics to find the correct ids.)

To help avoid failed uploads in the first place we now also support compressed uploads for API instances that allow them, in particular for the _openstreetmap.org_ instance (this can be enabled and disabled in the API configuration).

### Multiple OSM element clipboards

We now support multiple (5) clipboards for OSM elements, utilized in a most recently used stack fashion. In normal use there are no changes, simply cut or copy an object and it will be used for the next paste, you can however by clicking on one of the clipboard buttons in the menu bar before clicking on the map to determine the paste location, move that clipboard to the top and paste from that. The buttons will if available show the preset icon for the pasted element or a number in dicating the position in the stack.

Additionally, in _Paste multiple_ mode, you can now directly undo the last paste. Further you can paste a _Cut_ element more than once, the first _Paste_ retaining the original id and version, the following ones behaving as if the element had been copied. 

### Duplicate elements

You can now duplicate an OSM element directly without having to copy and paste. For ways you can choose between _Duplicate_, that is duplicate both the way and all nodes that construct it, and _Shallow duplicate_ that will duplicate the way but keep the references to the original nodes. Relations can only be duplicated with _Shallow duplicate_, that is, just as with ways, a duplicate of the relation maintaining the references to the original members. 

### Support selective upload from review modal

You can now select individual changes from the _Review changes_ modal for uploading directly from the dialog.

### Extract segment from way between two nodes

The extract segment function has been expanded to support extracting between two nodes on the same way and from closed ways.

### Other behaviour changes 

#### Use hardware rendering on Android 10 and later

Hardware rendering is now the default on devices with Android 10 or later. The preference for this has been removed on older devices and its location has been moved to the miscellaneous category of the _Advanced preferences_.

#### Copying tags

_Copy tags_ in the _Property editor_ now behaves (again) the same for both _Properties_ and _Details_ tabs. Previously copying in the later copied the tags both to the internal and the system clipboard, this has been changed to only copy to the internal tag clipboard and provide separate function to copy to the system clipboard.

#### Paste tags in multi-select mode

You can now paste tags from the tag internal clipboard to multiple elements at the same time. It goes to say that this functionality should be used carefully.

#### Element info modal available in the property editor

You can now display the element info modal in the property editor providing detailed information on the edited element.

#### More tags with multi-lingual variants

The _Add language variants_ function in the property editors _Properties_ tab now supports more tags, for example if an _addr:street_ tag is present it will add fields for the appropriate languages for the country the object is in. 

#### Automatically add an appropriate extension when saving files

If you save a file without an extension the app will now attempt to add an appropriate one.

#### Improve validation for area objects

We now use [osm-area-tags](https://github.com/simonpoole/osm-area-tags) to improve validation.

#### Selection state stored in undo checkpoints

Selection state is now stored in undo checkpoints allowing us to reselect elements after an undo in most cases.

#### Splitting an explicit or implied area shows a warning

If you split an area a warning will be displayed, as you might want to turn it in to a multi-polygon.

#### Completely disable auto-pruning

In some situations, for example when working on large relations, auto-pruning can be counter productive. We now provide a preference to turn it completely off.

#### Convert CSV file to GeoJSON

A CSV file with _lat_ and _lon_ columns with WGS 84 coordinates can be used to create a GeoJSON layer (the converted file will be stored locally).

#### GPX waypoints support for _link_ objects

_link_ objects in GPX waypoints are now displayed in the object modal and can be clicked (for example to play back a voice note).

#### Different colour icon for skipped todos

Skipped _todos_ are now displayed with a blue icon differentiating them from open and closed ones.

#### Code to render GPX tracks with multiple threads removed

For very long GPX tracks we were using multiple threads to render them, however as Androids canvas rendering framework is not actually thread safe this could lead
to random crashes.

#### Preset value type _date_ 

We now support a preset value type of date that will cause a date selector to be displayed in the property editor. This currently only supports single dates and not date ranges.

#### Improve way direction arrows rendering

Improves the rendering of way arrows, particularly for long ways so that there will nearly always be one visible on the map display.

#### Custom rendering for _crossing=unmarked_

Instead of displaying the preset pedestrian crossing icon, we now render a small red square for nodes with crossing unmarked and support directly referencing images in the assets folder from style files.

#### Disambiguation menu changes

Parent ways and relations are now enclosed in square brackets. Instead of ordering relations depth first, immediate parents of the clicked objects are listed before parents of the parent relations and so on.

## Miscellaneous

# Upgrading from previous versions

As a general precaution you should upload any pending changes before updating, particularly if you are upgrading from any major version that doesn't immediately precede this one. 

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
